%------------------------------------------------------------------------------
% File     : NUM754^1 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Number Theory
% Problem  : Landau theorem 62h
% Version  : Especial.
% English  : moref (pf z x) (pf u y)

% Refs     : [Lan30] Landau (1930), Grundlagen der Analysis
%          : [vBJ79] van Benthem Jutting (1979), Checking Landau's "Grundla
%          : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : satz62h [Lan30]

% Status   : Theorem
%          : Without extensionality : Theorem
% Rating   : 0.08 v7.4.0, 0.11 v7.3.0, 0.10 v7.2.0, 0.12 v7.1.0, 0.14 v7.0.0, 0.12 v6.4.0, 0.14 v6.3.0, 0.17 v6.2.0, 0.00 v6.1.0, 0.17 v5.5.0, 0.00 v5.3.0, 0.25 v5.2.0, 0.00 v3.7.0
% Syntax   : Number of formulae    :   14 (   0 unit;   8 type;   0 defn)
%            Number of atoms       :   45 (   0 equality;  20 variable)
%            Maximal formula depth :   11 (   4 average)
%            Number of connectives :   39 (   0   ~;   0   |;   0   &;  34   @)
%                                         (   0 <=>;   5  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    6 (   6   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   10 (   8   :;   0   =)
%            Number of variables   :   10 (   0 sgn;  10   !;   0   ?;   0   ^)
%                                         (  10   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_NEQ_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(frac_type,type,(
    frac: $tType )).

thf(x,type,(
    x: frac )).

thf(y,type,(
    y: frac )).

thf(z,type,(
    z: frac )).

thf(u,type,(
    u: frac )).

thf(eq,type,(
    eq: frac > frac > $o )).

thf(e,axiom,
    ( eq @ x @ y )).

thf(moref,type,(
    moref: frac > frac > $o )).

thf(m,axiom,
    ( moref @ z @ u )).

thf(pf,type,(
    pf: frac > frac > frac )).

thf(satz44,axiom,(
    ! [Xx: frac,Xy: frac,Xz: frac,Xu: frac] :
      ( ( moref @ Xx @ Xy )
     => ( ( eq @ Xx @ Xz )
       => ( ( eq @ Xy @ Xu )
         => ( moref @ Xz @ Xu ) ) ) ) )).

thf(satz62g,axiom,(
    ! [Xx: frac,Xy: frac,Xz: frac,Xu: frac] :
      ( ( eq @ Xx @ Xy )
     => ( ( moref @ Xz @ Xu )
       => ( moref @ ( pf @ Xx @ Xz ) @ ( pf @ Xy @ Xu ) ) ) ) )).

thf(satz58,axiom,(
    ! [Xx: frac,Xy: frac] :
      ( eq @ ( pf @ Xx @ Xy ) @ ( pf @ Xy @ Xx ) ) )).

thf(satz62h,conjecture,
    ( moref @ ( pf @ z @ x ) @ ( pf @ u @ y ) )).

%------------------------------------------------------------------------------
